//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
template <typename T>
union un_01
{
    T value;
    uchar u8_bits[sizeof(T)];
};
//+------------------------------------------------------------------+
void OnStart(void)
{
    Print("Demonstrating a mirror");

    Check((ulong)0xA1B2C3D4E5F6789A);
    Check((uint)0xFACADAFE);
    Check((ushort)0xCADE);
    Check((uchar)0xFE);
}
//+------------------------------------------------------------------+
template <typename T>
void Check(const T arg)
{
    un_01 <T> local;
    string sz;

    local.value = arg;
    PrintFormat("The region is composed of %d bytes", sizeof(local));
    PrintFormat("Before modification: 0x%I64X", local.value);
    PrintFormat("After modification : 0x%I64X", Mirror(local).value);
    StringInit(sz, 20, '*');
    Print(sz);
}
//+------------------------------------------------------------------+
template <typename T>
un_01 <T> Mirror(const un_01 <T> &arg)
{
    un_01 <T> local;

    for (uchar i = 0, j = sizeof(arg) - 1, tmp; i < j; i++, j--)
    {
        tmp = arg.u8_bits[i];
        local.u8_bits[i] = arg.u8_bits[j];
        local.u8_bits[j] = tmp;
    }

    return local;
}
//+------------------------------------------------------------------+